# Project: Simple Personal Website

**WHAT:**
A responsive, minimalist marketing website for a personal brand.
The project uses a standard web development stack: Next.js, React, TypeScript, Tailwind CSS.
The file structure is organized and logical.

**WHY:**
The goal is to create a sleek, professional, and high-performance website that converts visitors into users.
Focus on user experience (UX) and visual clarity over unnecessary complexity.

**HOW:**
*   **Design:** Adhere strictly to the existing Tailwind CSS configuration and component patterns. The aesthetic should be premium, clean, and modern.
*   **Responsiveness:** The website *must* adapt gracefully to all screen sizes (desktop, tablet, mobile).
*   **Code Quality:** Use clean, organized, and readable code. Prioritize the use of functional components and hooks in React. Ensure all code is type-safe using TypeScript.
*   **Testing:** Run tests using the existing Vitest configuration before finalizing any new feature or fix.
*   **Avoid:** Do not use any third-party icon libraries other than Lucide-React icons. Avoid excessive colors; stick to a single, cohesive color palette.

**Project Structure:**
*   `/src/pages`: Website pages
*   `/src/components`: Reusable components
*   `/src/styles`: Tailwind CSS files
*   `/public`: Static assets

**Key Commands:**
*   `npm run dev`: Run the development server.
*   `npm run build`: Build the project for production.
*   `npm run test`: Run all tests.
